/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsAp_error.h 47733 2014-08-27 09:28:22Z trieu                        $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         30.05.2012   TD
     Created
*******************************************************************************/

#ifndef __DNS_AP_ERROR_H
#define __DNS_AP_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// DNS AP Task (Dualport Application).
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DNS_APS_NOTREGISTERED
//
// MessageText:
//
//  User Application not registered.
//
#define TLR_E_DNS_APS_NOTREGISTERED      ((TLR_RESULT)0xC0630000L)

//
// MessageId: TLR_E_DNS_APS_ALREADY_REGISTERED
//
// MessageText:
//
//  User Application already registered.
//
#define TLR_E_DNS_APS_ALREADY_REGISTERED ((TLR_RESULT)0xC0630001L)

//
// MessageId: TLR_E_DNS_APS_PACKET_LENGTH_INVALID
//
// MessageText:
//
//  Invalid packet length for register/unregister command.
//
#define TLR_E_DNS_APS_PACKET_LENGTH_INVALID ((TLR_RESULT)0xC0630002L)

//
// MessageId: TLR_E_DNS_APS_ACCESS_FAIL
//
// MessageText:
//
//  Unregister application queue access failed.
//
#define TLR_E_DNS_APS_ACCESS_FAIL        ((TLR_RESULT)0xC0630003L)

//
// MessageId: TLR_E_DNS_APS_CONFIG_LOCK
//
// MessageText:
//
//  Function not allowed because configuration locked.
//
#define TLR_E_DNS_APS_CONFIG_LOCK        ((TLR_RESULT)0xC0630004L)

//
// MessageId: TLR_E_DNS_AP_NO_DATA_BASE
//
// MessageText:
//
//  No database available.
//
#define TLR_E_DNS_AP_NO_DATA_BASE        ((TLR_RESULT)0xC0630005L)

//
// MessageId: TLR_E_DNS_AP_OPEN_DATA_BASE
//
// MessageText:
//
//  Error open database.
//
#define TLR_E_DNS_AP_OPEN_DATA_BASE      ((TLR_RESULT)0xC0630006L)

//
// MessageId: TLR_E_DNS_AP_IV_DNS_DATA_BASE
//
// MessageText:
//
//  Not a valid DeviceNet Slave database.
//
#define TLR_E_DNS_AP_IV_DNS_DATA_BASE    ((TLR_RESULT)0xC0630007L)

//
// MessageId: TLR_E_DNS_AP_READ_DATA_BASE_TBL_GLB
//
// MessageText:
//
//  Error while rading table GLOBAL.
//
#define TLR_E_DNS_AP_READ_DATA_BASE_TBL_GLB ((TLR_RESULT)0xC0630008L)

//
// MessageId: TLR_E_DNS_AP_OPEN_DATA_BASE_TBL_GLB
//
// MessageText:
//
//  Error while open table GLOBAL.
//
#define TLR_E_DNS_AP_OPEN_DATA_BASE_TBL_GLB ((TLR_RESULT)0xC0630009L)

//
// MessageId: TLR_E_DNS_AP_OPEN_DATA_BASE_TBL_DNS
//
// MessageText:
//
//  Error while open table DNS.
//
#define TLR_E_DNS_AP_OPEN_DATA_BASE_TBL_DNS ((TLR_RESULT)0xC063000AL)

//
// MessageId: TLR_E_DNS_AP_READ_DATA_BASE_TBL_DNS
//
// MessageText:
//
//  Error while reading table DNS.
//
#define TLR_E_DNS_AP_READ_DATA_BASE_TBL_DNS ((TLR_RESULT)0xC063000BL)




#endif  //__DNS_AP_ERROR_H

